# Guardrail API — Student / Free Bundle (v0.1.0)

This bundle installs and runs the open-source **Guardrail Core Runtime** locally.

It is designed for students and independent learners who want to observe how Guardrail evaluates prompts and applies **allow / clarify / block** decisions through a simple local interface.

No configuration or tuning is required.

---

## Requirements

- **Python 3.11 or higher**
- **Git**
- **Windows users:** Git Bash is strongly recommended

Check your versions:

    python3 --version  # or: python --version
    git --version

If Python is older than 3.11, upgrade before continuing:
https://www.python.org/downloads/

---

## Install (one-time)

1. Open a terminal **in this folder**  
   (the same folder that contains `student-bootstrap.sh`).

2. Run:

    chmod +x student-bootstrap.sh
    ./student-bootstrap.sh

What this does:
- Clones the Guardrail Core Runtime repository
- Creates a Python virtual environment (`.venv`)
- Installs Guardrail Core locally

Windows note:  
To avoid long-path errors, the installer uses a short path by default:

    /c/guardrail/llm-guardrail-api-next

---

## Start the Guardrail server

After installation, start the Guardrail API server.

Windows (Git Bash):

    cd /c/guardrail/llm-guardrail-api-next
    source .venv/Scripts/activate
    uvicorn app.main:app --host 127.0.0.1 --port 8000

macOS / Linux / WSL:

    cd llm-guardrail-api-next
    source .venv/bin/activate
    uvicorn app.main:app --host 127.0.0.1 --port 8000

When the server starts, you should see output similar to:

    Uvicorn running on http://127.0.0.1:8000

Leave this terminal running while you use Guardrail.

To stop the server, press **Ctrl+C**.

---
## Using the Student UI

The Student bundle includes a **local Student UI** served directly by Guardrail Core.

Once the server is running, open your browser and go to:

    http://127.0.0.1:8000/student

From the Student UI, you can:
- Submit prompts through Guardrail
- Observe **allow / clarify / block** decisions
- View structured decision output returned by the Core

This Student UI is the **primary way** to interact with Guardrail in the Student bundle.


---

## If you closed VS Code or the terminal

No problem. Just restart the server.

Windows (Git Bash):

    cd /c/guardrail/llm-guardrail-api-next
    source .venv/Scripts/activate
    uvicorn app.main:app --host 127.0.0.1 --port 8000

macOS / Linux / WSL:

    cd llm-guardrail-api-next
    source .venv/bin/activate
    uvicorn app.main:app --host 127.0.0.1 --port 8000

Then reopen the Student UI.

---

## Optional: Direct API access (advanced users)

Guardrail runs as a REST API. Advanced users may send requests directly.

Examples are available in:

    examples/requests.http

You can also access the raw API documentation at:

    http://127.0.0.1:8000/docs

This is **optional** and not required for Student use.

---

## What to observe

As you submit prompts, Guardrail Core evaluates each request and returns a structured decision.

Depending on the request, it may:

- **allow** the request
- **request clarification**
- **block** the request

The Student bundle is intentionally simple and non-configurable so you can observe baseline Guardrail behavior before exploring higher-tier versions.

---

© 2025 Guardrail Labs, LLC  
Guardrail API — Patent Pending
